/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Constructor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JodaTimeConverter
implements Converter {
    private final DateTimeFormatter formatter = ISODateTimeFormat.dateTime();

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        DateTime dateTime = (DateTime)o;
        writer.setValue(this.formatter.print((ReadableInstant)dateTime));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String dateTimeStr = reader.getValue();
        Class requiredType = context.getRequiredType();
        try {
            Constructor constructor = requiredType.getConstructor(Object.class, DateTimeZone.class);
            return constructor.newInstance(dateTimeStr, DateTimeZone.UTC);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Error reading Joda DateTime from value %s: %s", dateTimeStr, e.getMessage()), (Throwable)e);
        }
    }

    public boolean canConvert(Class aClass) {
        return DateTime.class.isAssignableFrom(aClass);
    }
}

