/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.task;

import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.TaskOptions;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Producer;
import org.apache.camel.component.gae.bind.HttpBindingInvocationHandler;
import org.apache.camel.component.gae.bind.InboundBinding;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.component.gae.bind.OutboundBindingSupport;
import org.apache.camel.component.gae.task.GTaskProducer;
import org.apache.camel.component.servlet.ServletComponent;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="gtask", extendsScheme="servlet", title="Google Task", syntax="gtask:queueName", producerOnly=true, label="cloud")
public class GTaskEndpoint
extends ServletEndpoint
implements OutboundBindingSupport<GTaskEndpoint, TaskOptions, Void> {
    private OutboundBinding<GTaskEndpoint, TaskOptions, Void> outboundBinding;
    private InboundBinding<GTaskEndpoint, HttpServletRequest, HttpServletResponse> inboundBinding;
    private Queue queue;
    @UriPath
    @Metadata(required="true")
    private String queueName;
    @UriParam(label="producer", defaultValue="worker")
    private String workerRoot;
    @UriParam(label="consumer")
    private String inboundBindingRef;
    @UriParam(label="producer")
    private String outboundBindingRef;

    public GTaskEndpoint(String endpointUri, ServletComponent component, URI httpUri) throws URISyntaxException {
        super(endpointUri, component, httpUri);
    }

    @Override
    public OutboundBinding<GTaskEndpoint, TaskOptions, Void> getOutboundBinding() {
        return this.outboundBinding;
    }

    @Override
    public void setOutboundBinding(OutboundBinding<GTaskEndpoint, TaskOptions, Void> outboundBinding) {
        this.outboundBinding = outboundBinding;
    }

    public InboundBinding<GTaskEndpoint, HttpServletRequest, HttpServletResponse> getInboundBinding() {
        return this.inboundBinding;
    }

    public void setInboundBinding(InboundBinding<GTaskEndpoint, HttpServletRequest, HttpServletResponse> inboundBinding) {
        this.inboundBinding = inboundBinding;
    }

    public HttpBinding getBinding() {
        return (HttpBinding)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpBinding.class}, new HttpBindingInvocationHandler<GTaskEndpoint, HttpServletRequest, HttpServletResponse>(this, super.getBinding(), this.getInboundBinding()));
    }

    public String getWorkerRoot() {
        return this.workerRoot;
    }

    public void setWorkerRoot(String workerRoot) {
        this.workerRoot = workerRoot;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getInboundBindingRef() {
        return this.inboundBindingRef;
    }

    public void setInboundBindingRef(String inboundBindingRef) {
        this.inboundBindingRef = inboundBindingRef;
    }

    public String getOutboundBindingRef() {
        return this.outboundBindingRef;
    }

    public void setOutboundBindingRef(String outboundBindingRef) {
        this.outboundBindingRef = outboundBindingRef;
    }

    public Producer createProducer() throws Exception {
        return new GTaskProducer(this);
    }
}

