/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.univocity;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.AbstractWriter;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.CommonWriterSettings;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.processor.RowProcessor;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.univocity.HeaderRowProcessor;
import org.apache.camel.dataformat.univocity.Marshaller;
import org.apache.camel.dataformat.univocity.Unmarshaller;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;

public abstract class AbstractUniVocityDataFormat<F extends Format, CWS extends CommonWriterSettings<F>, W extends AbstractWriter<CWS>, CPS extends CommonParserSettings<F>, P extends AbstractParser<CPS>, DF extends AbstractUniVocityDataFormat<F, CWS, W, CPS, P, DF>>
extends ServiceSupport
implements DataFormat,
DataFormatName {
    protected String nullValue;
    protected Boolean skipEmptyLines;
    protected Boolean ignoreTrailingWhitespaces;
    protected Boolean ignoreLeadingWhitespaces;
    protected boolean headersDisabled;
    protected String[] headers;
    protected Boolean headerExtractionEnabled;
    protected Integer numberOfRecordsToRead;
    protected String emptyValue;
    protected String lineSeparator;
    protected Character normalizedLineSeparator;
    protected Character comment;
    protected boolean lazyLoad;
    protected boolean asMap;
    private volatile CWS writerSettings;
    private final Object writerSettingsToken = new Object();
    private volatile Marshaller<W> marshaller;
    private volatile ThreadLocal<CPS> parserSettings;
    private final Object parserSettingsToken = new Object();
    private volatile Unmarshaller<P> unmarshaller;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        if (this.writerSettings == null) {
            Object object = this.writerSettingsToken;
            synchronized (object) {
                if (this.writerSettings == null) {
                    this.writerSettings = this.createAndConfigureWriterSettings();
                    this.marshaller = new Marshaller(this.headers, this.headers == null);
                }
            }
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, IOHelper.getCharsetName((Exchange)exchange));){
            this.marshaller.marshal(exchange, body, this.createWriter(writer, this.writerSettings));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        if (this.parserSettings == null) {
            Object object = this.parserSettingsToken;
            synchronized (object) {
                if (this.parserSettings == null) {
                    this.parserSettings = new ThreadLocal<CPS>(){

                        @Override
                        protected CPS initialValue() {
                            return AbstractUniVocityDataFormat.this.createAndConfigureParserSettings();
                        }
                    };
                    this.unmarshaller = new Unmarshaller(this.lazyLoad, this.asMap);
                }
            }
        }
        try (InputStreamReader reader = new InputStreamReader(stream, IOHelper.getCharsetName((Exchange)exchange));){
            HeaderRowProcessor headerRowProcessor = new HeaderRowProcessor();
            CommonParserSettings settings = (CommonParserSettings)this.parserSettings.get();
            settings.setRowProcessor((RowProcessor)headerRowProcessor);
            Object object = this.unmarshaller.unmarshal(reader, this.createParser(settings), headerRowProcessor);
            return object;
        }
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public DF setNullValue(String nullValue) {
        this.nullValue = nullValue;
        return this.self();
    }

    public Boolean getSkipEmptyLines() {
        return this.skipEmptyLines;
    }

    public DF setSkipEmptyLines(Boolean skipEmptyLines) {
        this.skipEmptyLines = skipEmptyLines;
        return this.self();
    }

    public Boolean getIgnoreTrailingWhitespaces() {
        return this.ignoreTrailingWhitespaces;
    }

    public DF setIgnoreTrailingWhitespaces(Boolean ignoreTrailingWhitespaces) {
        this.ignoreTrailingWhitespaces = ignoreTrailingWhitespaces;
        return this.self();
    }

    public Boolean getIgnoreLeadingWhitespaces() {
        return this.ignoreLeadingWhitespaces;
    }

    public DF setIgnoreLeadingWhitespaces(Boolean ignoreLeadingWhitespaces) {
        this.ignoreLeadingWhitespaces = ignoreLeadingWhitespaces;
        return this.self();
    }

    public boolean isHeadersDisabled() {
        return this.headersDisabled;
    }

    public DF setHeadersDisabled(boolean headersDisabled) {
        this.headersDisabled = headersDisabled;
        return this.self();
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public DF setHeaders(String[] headers) {
        this.headers = headers;
        return this.self();
    }

    public Boolean getHeaderExtractionEnabled() {
        return this.headerExtractionEnabled;
    }

    public DF setHeaderExtractionEnabled(Boolean headerExtractionEnabled) {
        this.headerExtractionEnabled = headerExtractionEnabled;
        return this.self();
    }

    public Integer getNumberOfRecordsToRead() {
        return this.numberOfRecordsToRead;
    }

    public DF setNumberOfRecordsToRead(Integer numberOfRecordsToRead) {
        this.numberOfRecordsToRead = numberOfRecordsToRead;
        return this.self();
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public DF setEmptyValue(String emptyValue) {
        this.emptyValue = emptyValue;
        return this.self();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public DF setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
        return this.self();
    }

    public Character getNormalizedLineSeparator() {
        return this.normalizedLineSeparator;
    }

    public DF setNormalizedLineSeparator(Character normalizedLineSeparator) {
        this.normalizedLineSeparator = normalizedLineSeparator;
        return this.self();
    }

    public Character getComment() {
        return this.comment;
    }

    public DF setComment(Character comment) {
        this.comment = comment;
        return this.self();
    }

    public boolean isLazyLoad() {
        return this.lazyLoad;
    }

    public DF setLazyLoad(boolean lazyLoad) {
        this.lazyLoad = lazyLoad;
        return this.self();
    }

    public boolean isAsMap() {
        return this.asMap;
    }

    public DF setAsMap(boolean asMap) {
        this.asMap = asMap;
        return this.self();
    }

    protected abstract CWS createWriterSettings();

    protected void configureWriterSettings(CWS settings) {
        this.configureCommonSettings((CommonSettings<F>)settings);
        if (this.emptyValue != null) {
            settings.setEmptyValue(this.emptyValue);
        }
    }

    protected abstract W createWriter(Writer var1, CWS var2);

    protected abstract CPS createParserSettings();

    protected void configureParserSettings(CPS settings) {
        this.configureCommonSettings((CommonSettings<F>)settings);
        if (this.headerExtractionEnabled != null) {
            settings.setHeaderExtractionEnabled(this.headerExtractionEnabled.booleanValue());
        }
        if (this.numberOfRecordsToRead != null) {
            settings.setNumberOfRecordsToRead(this.numberOfRecordsToRead.intValue());
        }
    }

    protected abstract P createParser(CPS var1);

    protected void configureFormat(F format) {
        if (this.lineSeparator != null) {
            format.setLineSeparator(this.lineSeparator);
        }
        if (this.normalizedLineSeparator != null) {
            format.setNormalizedNewline(this.normalizedLineSeparator.charValue());
        }
        if (this.comment != null) {
            format.setComment(this.comment.charValue());
        }
    }

    final CWS createAndConfigureWriterSettings() {
        CWS settings = this.createWriterSettings();
        this.configureWriterSettings(settings);
        this.configureFormat(settings.getFormat());
        return settings;
    }

    final CPS createAndConfigureParserSettings() {
        CPS settings = this.createParserSettings();
        this.configureParserSettings(settings);
        this.configureFormat(settings.getFormat());
        return settings;
    }

    private void configureCommonSettings(CommonSettings<F> settings) {
        if (this.nullValue != null) {
            settings.setNullValue(this.nullValue);
        }
        if (this.skipEmptyLines != null) {
            settings.setSkipEmptyLines(this.skipEmptyLines.booleanValue());
        }
        if (this.ignoreTrailingWhitespaces != null) {
            settings.setIgnoreTrailingWhitespaces(this.ignoreTrailingWhitespaces.booleanValue());
        }
        if (this.ignoreLeadingWhitespaces != null) {
            settings.setIgnoreLeadingWhitespaces(this.ignoreLeadingWhitespaces.booleanValue());
        }
        if (this.headersDisabled) {
            settings.setHeaders((String[])null);
        } else if (this.headers != null) {
            settings.setHeaders(this.headers);
        }
    }

    private DF self() {
        return (DF)((Object)this);
    }

    protected void doStart() throws Exception {
        this.writerSettings = null;
        this.marshaller = null;
        this.parserSettings = null;
        this.unmarshaller = null;
    }

    protected void doStop() throws Exception {
    }
}

