/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinallyProcessor
extends DelegateAsyncProcessor
implements Traceable {
    private static final Logger LOG = LoggerFactory.getLogger(FinallyProcessor.class);

    public FinallyProcessor(Processor processor) {
        super(processor);
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final Exception e = exchange.getException();
        exchange.setException(null);
        if (e != null) {
            exchange.setProperty("CamelExceptionCaught", e);
        }
        if (exchange.getProperty("CamelFailureEndpoint") == null) {
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
        }
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (e == null) {
                    exchange.removeProperty("CamelFailureEndpoint");
                } else {
                    exchange.setException(e);
                    exchange.setProperty("CamelExceptionCaught", e);
                }
                if (!doneSync) {
                    ExchangeHelper.prepareOutToIn(exchange);
                    LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                }
                callback.done(doneSync);
            }
        });
        return sync;
    }

    @Override
    public String toString() {
        return "Finally{" + this.getProcessor() + "}";
    }

    @Override
    public String getTraceLabel() {
        return "finally";
    }
}

