/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hl7.HL7Charset;
import org.apache.camel.component.hl7.HL7Converter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;

public class HL7DataFormat
extends ServiceSupport
implements DataFormat {
    private static final Map<String, String> HEADER_MAP = new HashMap<String, String>();
    private HapiContext hapiContext;
    private Parser parser;
    private boolean validate = true;

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        Message message = (Message)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Message.class, (Object)body);
        String charsetName = HL7Charset.getCharsetName(message, exchange);
        String encoded = HL7Converter.encode(message, this.parser);
        outputStream.write(encoded.getBytes(charsetName));
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        byte[] body = (byte[])ExchangeHelper.convertToMandatoryType((Exchange)exchange, byte[].class, (Object)inputStream);
        String charsetName = HL7Charset.getCharsetName(body, this.guessCharsetName(body, exchange));
        String bodyAsString = new String(body, charsetName);
        Message message = HL7Converter.parse(bodyAsString, this.parser);
        Terser terser = new Terser(message);
        for (Map.Entry<String, String> entry : HEADER_MAP.entrySet()) {
            exchange.getOut().setHeader(entry.getKey(), (Object)terser.get(entry.getValue()));
        }
        exchange.getOut().setHeader("CamelHL7Context", (Object)this.hapiContext);
        exchange.getOut().setHeader("CamelCharsetName", (Object)charsetName);
        return message;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public HapiContext getHapiContext() {
        return this.hapiContext;
    }

    public void setHapiContext(HapiContext context) {
        this.hapiContext = context;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    protected void doStart() throws Exception {
        if (this.hapiContext == null) {
            this.hapiContext = new DefaultHapiContext();
        }
        if (this.parser == null) {
            this.parser = this.hapiContext.getGenericParser();
        }
        if (!this.validate) {
            this.parser.setValidationContext(ValidationContextFactory.noValidation());
        }
    }

    protected void doStop() throws Exception {
    }

    protected String guessCharsetName(byte[] b, Exchange exchange) {
        return IOHelper.getCharsetName((Exchange)exchange);
    }

    static {
        HEADER_MAP.put("CamelHL7SendingApplication", "MSH-3");
        HEADER_MAP.put("CamelHL7SendingFacility", "MSH-4");
        HEADER_MAP.put("CamelHL7ReceivingApplication", "MSH-5");
        HEADER_MAP.put("CamelHL7ReceivingFacility", "MSH-6");
        HEADER_MAP.put("CamelHL7Timestamp", "MSH-7");
        HEADER_MAP.put("CamelHL7Security", "MSH-8");
        HEADER_MAP.put("CamelHL7MessageType", "MSH-9-1");
        HEADER_MAP.put("CamelHL7TriggerEvent", "MSH-9-2");
        HEADER_MAP.put("CamelHL7MessageControl", "MSH-10");
        HEADER_MAP.put("CamelHL7ProcessingId", "MSH-11");
        HEADER_MAP.put("CamelHL7VersionId", "MSH-12");
        HEADER_MAP.put("CamelHL7Charset", "MSH-18");
    }
}

