/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ses;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.ses.SesConfiguration;
import org.apache.camel.component.aws.ses.SesProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(scheme="aws-ses", title="AWS Simple Email Service", syntax="aws-ses:from", producerOnly=true, label="cloud,mail")
public class SesEndpoint
extends DefaultEndpoint {
    private AmazonSimpleEmailService sesClient;
    @UriParam
    private SesConfiguration configuration;

    @Deprecated
    public SesEndpoint(String uri, CamelContext context, SesConfiguration configuration) {
        super(uri, context);
        this.configuration = configuration;
    }

    public SesEndpoint(String uri, Component component, SesConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public void doStart() throws Exception {
        super.doStart();
        AmazonSimpleEmailService amazonSimpleEmailService = this.sesClient = this.configuration.getAmazonSESClient() != null ? this.configuration.getAmazonSESClient() : this.createSESClient();
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getAmazonSESEndpoint())) {
            this.sesClient.setEndpoint(this.configuration.getAmazonSESEndpoint());
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new SesProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public SesConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonSimpleEmailService getSESClient() {
        return this.sesClient;
    }

    private AmazonSimpleEmailService createSESClient() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
        AmazonSimpleEmailServiceClient client = new AmazonSimpleEmailServiceClient((AWSCredentials)credentials);
        return client;
    }
}

