/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.Condition;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.QueryRequest;
import com.amazonaws.services.dynamodb.model.QueryResult;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class QueryCommand
extends AbstractDdbCommand {
    public QueryCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        QueryResult result = this.ddbClient.query(new QueryRequest().withTableName(this.determineTableName()).withAttributesToGet(this.determineAttributeNames()).withCount(this.determineExactCount()).withConsistentRead(this.determineConsistentRead()).withExclusiveStartKey(this.determineStartKey()).withHashKeyValue(this.determineHashKeyValue()).withLimit(this.determineLimit()).withRangeKeyCondition(this.determineRangeKeyCondition()).withScanIndexForward(this.determineScanIndexForward()));
        this.addToResult("CamelAwsDdbItems", result.getItems());
        this.addToResult("CamelAwsDdbLastEvaluatedKey", result.getLastEvaluatedKey());
        this.addToResult("CamelAwsDdbConsumedCapacity", result.getConsumedCapacityUnits());
        this.addToResult("CamelAwsDdbCount", result.getCount());
    }

    private Key determineStartKey() {
        return (Key)this.exchange.getIn().getHeader("CamelAwsDdbStartKey", Key.class);
    }

    private Boolean determineScanIndexForward() {
        return (Boolean)this.exchange.getIn().getHeader("CamelAwsDdbScanIndexForward", Boolean.class);
    }

    private Condition determineRangeKeyCondition() {
        return (Condition)this.exchange.getIn().getHeader("CamelAwsDdbScanRangeKeyCondition", Condition.class);
    }

    private Integer determineLimit() {
        return (Integer)this.exchange.getIn().getHeader("CamelAwsDdbLimit", Integer.class);
    }

    private AttributeValue determineHashKeyValue() {
        return (AttributeValue)this.exchange.getIn().getHeader("CamelAwsDdbHashKeyValue", AttributeValue.class);
    }

    private Boolean determineExactCount() {
        return (Boolean)this.exchange.getIn().getHeader("CamelAwsDdbExactCount", Boolean.class);
    }
}

