/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.model.DeleteTableRequest;
import com.amazonaws.services.dynamodb.model.TableDescription;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class DeleteTableCommand
extends AbstractDdbCommand {
    public DeleteTableCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        TableDescription tableDescription = this.ddbClient.deleteTable(new DeleteTableRequest(this.determineTableName())).getTableDescription();
        this.addToResult("CamelAwsDdbProvisionedThroughput", tableDescription.getProvisionedThroughput());
        this.addToResult("CamelAwsDdbCreationDate", tableDescription.getCreationDateTime());
        this.addToResult("CamelAwsDdbTableItemCount", tableDescription.getItemCount());
        this.addToResult("CamelAwsDdbKeySchema", tableDescription.getKeySchema());
        this.addToResult("CamelAwsDdbTableName", tableDescription.getTableName());
        this.addToResult("CamelAwsDdbTableSize", tableDescription.getTableSizeBytes());
        this.addToResult("CamelAwsDdbTableStatus", tableDescription.getTableStatus());
    }
}

