/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cw;

import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.cw.CwConfiguration;
import org.apache.camel.component.aws.cw.CwEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.URISupport;

public class CwProducer
extends DefaultProducer {
    public CwProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        List<MetricDatum> metricData = this.getMetricData(exchange);
        PutMetricDataRequest request = new PutMetricDataRequest().withMetricData(metricData).withNamespace(this.determineNameSpace(exchange));
        this.log.info("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        this.getEndpoint().getCloudWatchClient().putMetricData(request);
    }

    private List<MetricDatum> getMetricData(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        if (body instanceof List) {
            return CastUtils.cast((List)((List)body));
        }
        if (body instanceof MetricDatum) {
            return Arrays.asList((MetricDatum)body);
        }
        MetricDatum metricDatum = new MetricDatum().withMetricName(this.determineName(exchange)).withValue(this.determineValue(exchange)).withUnit(this.determineUnit(exchange)).withTimestamp(this.determineTimestamp(exchange));
        this.setDimension(metricDatum, exchange);
        return Arrays.asList(metricDatum);
    }

    private void setDimension(MetricDatum metricDatum, Exchange exchange) {
        String name = (String)exchange.getIn().getHeader("CamelAwsCwMetricDimensionName", String.class);
        String value = (String)exchange.getIn().getHeader("CamelAwsCwMetricDimensionValue", String.class);
        if (name != null && value != null) {
            metricDatum.withDimensions(new Dimension[]{new Dimension().withName(name).withValue(value)});
        } else {
            Map dimensions = (Map)exchange.getIn().getHeader("CamelAwsCwMetricDimensions", Map.class);
            if (dimensions != null) {
                ArrayList<Dimension> dimensionCollection = new ArrayList<Dimension>();
                for (Map.Entry dimensionEntry : dimensions.entrySet()) {
                    Dimension dimension = new Dimension().withName((String)dimensionEntry.getKey()).withValue((String)dimensionEntry.getValue());
                    dimensionCollection.add(dimension);
                }
                metricDatum.withDimensions(dimensionCollection);
            }
        }
    }

    private Date determineTimestamp(Exchange exchange) {
        Date timestamp = (Date)exchange.getIn().getHeader("CamelAwsCwMetricTimestamp", Date.class);
        if (timestamp == null) {
            timestamp = this.getConfiguration().getTimestamp();
        }
        return timestamp;
    }

    private String determineNameSpace(Exchange exchange) {
        String namespace = (String)exchange.getIn().getHeader("CamelAwsCwMetricNamespace", String.class);
        if (namespace == null) {
            namespace = this.getConfiguration().getNamespace();
        }
        return namespace;
    }

    private String determineName(Exchange exchange) {
        String name = (String)exchange.getIn().getHeader("CamelAwsCwMetricName", String.class);
        if (name == null) {
            name = this.getConfiguration().getName();
        }
        return name;
    }

    private Double determineValue(Exchange exchange) {
        Double value = (Double)exchange.getIn().getHeader("CamelAwsCwMetricValue", Double.class);
        if (value == null) {
            value = this.getConfiguration().getValue();
        }
        return value != null ? value : Double.valueOf(1.0);
    }

    private StandardUnit determineUnit(Exchange exchange) {
        String unit = (String)exchange.getIn().getHeader("CamelAwsCwMetricUnit", String.class);
        if (unit == null) {
            unit = this.getConfiguration().getUnit();
        }
        return unit != null ? StandardUnit.valueOf((String)unit) : StandardUnit.Count;
    }

    protected CwConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        return "CwProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }

    public CwEndpoint getEndpoint() {
        return (CwEndpoint)super.getEndpoint();
    }
}

