/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxResult;
import org.apache.camel.component.dropbox.integration.producer.DropboxProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropboxPutProducer
extends DropboxProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(DropboxPutProducer.class);

    public DropboxPutProducer(DropboxEndpoint endpoint, DropboxConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        DropboxResult result = DropboxAPIFacade.getInstance(this.configuration.getClient()).put(this.configuration.getLocalPath(), this.configuration.getRemotePath(), this.configuration.getUploadMode());
        result.populateExchange(exchange);
        LOG.info("Uploaded: " + result.toString());
    }
}

