/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yammer;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.yammer.YammerEndpoint;
import org.apache.camel.component.yammer.YammerFunctionType;
import org.apache.camel.component.yammer.model.User;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;

public class YammerUserPollingConsumer
extends ScheduledPollConsumer {
    private final YammerEndpoint endpoint;
    private final String apiUrl;

    public YammerUserPollingConsumer(YammerEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        long delay = endpoint.getConfig().getDelay();
        this.setDelay(delay);
        this.setTimeUnit(TimeUnit.MILLISECONDS);
        this.apiUrl = this.getApiUrl();
    }

    private String getApiUrl() throws Exception {
        StringBuilder url = new StringBuilder();
        String function = this.endpoint.getConfig().getFunction();
        switch (YammerFunctionType.fromUri(function)) {
            case USERS: {
                url.append("https://www.yammer.com/api/v1/");
                url.append(function);
                url.append(".json");
                break;
            }
            case CURRENT: {
                url.append("https://www.yammer.com/api/v1/");
                url.append("users/");
                url.append(function);
                url.append(".json");
                break;
            }
            default: {
                throw new Exception(String.format("%s is not a valid Yammer user function type.", function));
            }
        }
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        Exchange exchange = this.endpoint.createExchange();
        try {
            String jsonBody = this.endpoint.getConfig().getRequestor(this.apiUrl).get();
            if (!this.endpoint.getConfig().isUseJson()) {
                ObjectMapper jsonMapper = new ObjectMapper();
                String function = this.endpoint.getConfig().getFunction();
                switch (YammerFunctionType.fromUri(function)) {
                    case USERS: {
                        List users = (List)jsonMapper.readValue(jsonBody, (JavaType)jsonMapper.getTypeFactory().constructCollectionType(List.class, User.class));
                        exchange.getIn().setBody((Object)users);
                        break;
                    }
                    case CURRENT: {
                        User user = (User)jsonMapper.readValue(jsonBody, jsonMapper.getTypeFactory().constructType(User.class));
                        exchange.getIn().setBody((Object)user);
                        break;
                    }
                    default: {
                        throw new Exception(String.format("%s is not a valid Yammer user function type.", function));
                    }
                }
            } else {
                exchange.getIn().setBody((Object)jsonBody);
            }
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

