/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc.ws;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketByteListener;
import com.ning.http.client.ws.WebSocketListener;
import com.ning.http.client.ws.WebSocketTextListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ahc.AhcComponent;
import org.apache.camel.component.ahc.AhcEndpoint;
import org.apache.camel.component.ahc.ws.WsComponent;
import org.apache.camel.component.ahc.ws.WsConsumer;
import org.apache.camel.component.ahc.ws.WsProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="ahc-ws,ahc-wss", title="AHC Websocket,AHC Secure Websocket", syntax="ahc-ws:httpUri", consumerClass=WsConsumer.class, label="http,websocket")
public class WsEndpoint
extends AhcEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(WsEndpoint.class);
    private static final boolean GRIZZLY_AVAILABLE = WsEndpoint.probeClass("com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider");
    private final Set<WsConsumer> consumers = new HashSet<WsConsumer>();
    private WebSocket websocket;
    @UriParam
    private boolean useStreaming;

    public WsEndpoint(String endpointUri, WsComponent component) {
        super(endpointUri, (AhcComponent)component, null);
    }

    private static boolean probeClass(String name) {
        try {
            Class.forName(name, true, WsEndpoint.class.getClassLoader());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public WsComponent getComponent() {
        return (WsComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        return new WsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new WsConsumer(this, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebSocket getWebSocket() throws Exception {
        WsEndpoint wsEndpoint = this;
        synchronized (wsEndpoint) {
            if (this.websocket == null) {
                this.connect();
            }
        }
        return this.websocket;
    }

    void setWebSocket(WebSocket websocket) {
        this.websocket = websocket;
    }

    public boolean isUseStreaming() {
        return this.useStreaming;
    }

    public void setUseStreaming(boolean useStreaming) {
        this.useStreaming = useStreaming;
    }

    protected AsyncHttpClient createClient(AsyncHttpClientConfig config) {
        AsyncHttpProvider ahp;
        if (config == null) {
            config = new AsyncHttpClientConfig.Builder().build();
        }
        AsyncHttpClient client = (ahp = this.getAsyncHttpProvider(config)) == null ? new AsyncHttpClient(config) : new AsyncHttpClient(ahp, config);
        return client;
    }

    public void connect() throws Exception {
        String uri = this.getHttpUri().toASCIIString();
        LOG.debug("Connecting to {}", (Object)uri);
        this.websocket = (WebSocket)this.getClient().prepareGet(uri).execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new WsListener()).build()).get();
    }

    protected void doStop() throws Exception {
        if (this.websocket != null && this.websocket.isOpen()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Disconnecting from {}", (Object)this.getHttpUri().toASCIIString());
            }
            this.websocket.close();
            this.websocket = null;
        }
        super.doStop();
    }

    void connect(WsConsumer wsConsumer) throws Exception {
        this.consumers.add(wsConsumer);
        if (this.websocket == null || !this.websocket.isOpen()) {
            this.connect();
        }
    }

    void disconnect(WsConsumer wsConsumer) {
        this.consumers.remove((Object)wsConsumer);
    }

    protected AsyncHttpProvider getAsyncHttpProvider(AsyncHttpClientConfig config) {
        if (GRIZZLY_AVAILABLE) {
            return new GrizzlyAsyncHttpProvider(config);
        }
        return null;
    }

    class WsListener
    implements WebSocketTextListener,
    WebSocketByteListener {
        WsListener() {
        }

        public void onOpen(WebSocket websocket) {
            LOG.debug("websocket opened");
        }

        public void onClose(WebSocket websocket) {
            LOG.debug("websocket closed");
        }

        public void onError(Throwable t) {
            LOG.error("websocket on error", t);
        }

        public void onMessage(byte[] message) {
            LOG.debug("Received message --> {}", (Object)message);
            for (WsConsumer consumer : WsEndpoint.this.consumers) {
                consumer.sendMessage(message);
            }
        }

        public void onMessage(String message) {
            LOG.debug("Received message --> {}", (Object)message);
            for (WsConsumer consumer : WsEndpoint.this.consumers) {
                consumer.sendMessage(message);
            }
        }
    }
}

