/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.utils.cassandra;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;

public final class CassandraUtils {
    private CassandraUtils() {
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static Object[] concat(Object[] array1, Object[] array2) {
        if (CassandraUtils.isEmpty(array1)) {
            return array2;
        }
        if (CassandraUtils.isEmpty(array2)) {
            return array1;
        }
        Object[] array = new Object[array1.length + array2.length];
        System.arraycopy(array1, 0, array, 0, array1.length);
        System.arraycopy(array2, 0, array, array1.length, array2.length);
        return array;
    }

    private static int size(String[] array) {
        return array == null ? 0 : array.length;
    }

    private static boolean isEmpty(String[] array) {
        return CassandraUtils.size(array) == 0;
    }

    public static String[] concat(String[] array1, String[] array2) {
        if (CassandraUtils.isEmpty(array1)) {
            return array2;
        }
        if (CassandraUtils.isEmpty(array2)) {
            return array1;
        }
        String[] array = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, array, 0, array1.length);
        System.arraycopy(array2, 0, array, array1.length, array2.length);
        return array;
    }

    public static Object[] append(Object[] array1, Object ... array2) {
        return CassandraUtils.concat(array1, array2);
    }

    public static String[] append(String[] array1, String ... array2) {
        return CassandraUtils.concat(array1, array2);
    }

    public static Insert generateInsert(String table, String[] columns, boolean ifNotExists, Integer ttl) {
        Insert insert = QueryBuilder.insertInto((String)table);
        for (String column : columns) {
            insert = insert.value(column, (Object)QueryBuilder.bindMarker());
        }
        if (ifNotExists) {
            insert = insert.ifNotExists();
        }
        if (ttl != null) {
            insert.using(QueryBuilder.ttl((int)ttl));
        }
        return insert;
    }

    public static Select generateSelect(String table, String[] selectColumns, String[] whereColumns) {
        return CassandraUtils.generateSelect(table, selectColumns, whereColumns, CassandraUtils.size(whereColumns));
    }

    public static Select generateSelect(String table, String[] selectColumns, String[] whereColumns, int whereColumnsMaxIndex) {
        Select select = QueryBuilder.select((String[])selectColumns).from(table);
        if (CassandraUtils.isWhereClause(whereColumns, whereColumnsMaxIndex)) {
            Select.Where where = select.where();
            for (int i = 0; i < whereColumns.length && i < whereColumnsMaxIndex; ++i) {
                where.and(QueryBuilder.eq((String)whereColumns[i], (Object)QueryBuilder.bindMarker()));
            }
        }
        return select;
    }

    public static Delete generateDelete(String table, String[] whereColumns, boolean ifExists) {
        return CassandraUtils.generateDelete(table, whereColumns, CassandraUtils.size(whereColumns), ifExists);
    }

    public static Delete generateDelete(String table, String[] whereColumns, int whereColumnsMaxIndex, boolean ifExists) {
        Delete delete = QueryBuilder.delete().from(table);
        if (CassandraUtils.isWhereClause(whereColumns, whereColumnsMaxIndex)) {
            Delete.Where where = delete.where();
            for (int i = 0; i < whereColumns.length && i < whereColumnsMaxIndex; ++i) {
                where.and(QueryBuilder.eq((String)whereColumns[i], (Object)QueryBuilder.bindMarker()));
            }
        }
        if (ifExists) {
            delete = delete.ifExists();
        }
        return delete;
    }

    private static boolean isWhereClause(String[] whereColumns, int whereColumnsMaxIndex) {
        return !CassandraUtils.isEmpty(whereColumns) && whereColumnsMaxIndex > 0;
    }

    public static <T extends RegularStatement> T applyConsistencyLevel(T statement, ConsistencyLevel consistencyLevel) {
        if (consistencyLevel != null) {
            statement.setConsistencyLevel(consistencyLevel);
        }
        return statement;
    }
}

