/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Select;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.utils.cassandra.CassandraSessionHolder;
import org.apache.camel.utils.cassandra.CassandraUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraIdempotentRepository<K>
extends ServiceSupport
implements IdempotentRepository<K> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraIdempotentRepository.class);
    private CassandraSessionHolder sessionHolder;
    private String table = "CAMEL_IDEMPOTENT";
    private Object[] prefixPKValues = new Object[0];
    private String[] pkColumns = new String[]{"KEY"};
    private Integer ttl;
    private ConsistencyLevel writeConsistencyLevel;
    private ConsistencyLevel readConsistencyLevel;
    private PreparedStatement insertStatement;
    private PreparedStatement selectStatement;
    private PreparedStatement deleteStatement;

    public CassandraIdempotentRepository() {
    }

    public CassandraIdempotentRepository(Session session) {
        this.sessionHolder = new CassandraSessionHolder(session);
    }

    public CassandraIdempotentRepository(Cluster cluster, String keyspace) {
        this.sessionHolder = new CassandraSessionHolder(cluster, keyspace);
    }

    private boolean isKey(ResultSet resultSet) {
        Row row = resultSet.one();
        if (row == null) {
            LOGGER.debug("No row to check key");
            return false;
        }
        LOGGER.debug("Row with {} columns to check key", (Object)row.getColumnDefinitions());
        return row.getColumnDefinitions().size() >= this.pkColumns.length;
    }

    protected final boolean isApplied(ResultSet resultSet) {
        Row row = resultSet.one();
        return row == null || row.getBool("[applied]");
    }

    protected Object[] getPKValues(K key) {
        return CassandraUtils.append(this.prefixPKValues, key);
    }

    protected void doStart() throws Exception {
        this.sessionHolder.start();
        this.initInsertStatement();
        this.initSelectStatement();
        this.initDeleteStatement();
    }

    protected void doStop() throws Exception {
        this.sessionHolder.stop();
    }

    protected void initInsertStatement() {
        Insert insert = CassandraUtils.generateInsert(this.table, this.pkColumns, true, this.ttl);
        insert = CassandraUtils.applyConsistencyLevel(insert, this.writeConsistencyLevel);
        LOGGER.debug("Generated Insert {}", (Object)insert);
        this.insertStatement = this.getSession().prepare((RegularStatement)insert);
    }

    public boolean add(K key) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Inserting key {}", (Object)idValues);
        return this.isApplied(this.getSession().execute((Statement)this.insertStatement.bind(idValues)));
    }

    protected void initSelectStatement() {
        Select select = CassandraUtils.generateSelect(this.table, this.pkColumns, this.pkColumns);
        select = CassandraUtils.applyConsistencyLevel(select, this.readConsistencyLevel);
        LOGGER.debug("Generated Select {}", (Object)select);
        this.selectStatement = this.getSession().prepare((RegularStatement)select);
    }

    public boolean contains(K key) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Checking key {}", (Object)idValues);
        return this.isKey(this.getSession().execute((Statement)this.selectStatement.bind(idValues)));
    }

    public boolean confirm(K key) {
        return true;
    }

    protected void initDeleteStatement() {
        Delete delete = CassandraUtils.generateDelete(this.table, this.pkColumns, true);
        delete = CassandraUtils.applyConsistencyLevel(delete, this.writeConsistencyLevel);
        LOGGER.debug("Generated Delete {}", (Object)delete);
        this.deleteStatement = this.getSession().prepare((RegularStatement)delete);
    }

    public boolean remove(K key) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Deleting key {}", (Object)idValues);
        return this.isApplied(this.getSession().execute((Statement)this.deleteStatement.bind(idValues)));
    }

    public Session getSession() {
        return this.sessionHolder.getSession();
    }

    public void setSession(Session session) {
        this.sessionHolder = new CassandraSessionHolder(session);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String[] getPKColumns() {
        return this.pkColumns;
    }

    public void setPKColumns(String ... pkColumns) {
        this.pkColumns = pkColumns;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public void setWriteConsistencyLevel(ConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(ConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public Object[] getPrefixPKValues() {
        return this.prefixPKValues;
    }

    public void setPrefixPKValues(Object[] prefixPKValues) {
        this.prefixPKValues = prefixPKValues;
    }
}

