/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.http.HttpServerBootstrapFactory;
import org.apache.camel.component.netty.http.JAASSecurityAuthenticator;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpComponent;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpConsumer;
import org.apache.camel.component.netty.http.NettyHttpHelper;
import org.apache.camel.component.netty.http.NettyHttpProducer;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty.http.NettySharedHttpServer;
import org.apache.camel.impl.SynchronousDelegateProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="netty-http", title="Netty HTTP", syntax="netty-http:host:port/path", consumerClass=NettyHttpConsumer.class, label="http")
public class NettyHttpEndpoint
extends NettyEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpEndpoint.class);
    private NettyHttpBinding nettyHttpBinding;
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam
    private NettyHttpConfiguration configuration;
    @UriParam
    private boolean traceEnabled;
    @UriParam
    private String httpMethodRestrict;
    private NettySharedHttpServer nettySharedHttpServer;
    private NettyHttpSecurityConfiguration securityConfiguration;

    public NettyHttpEndpoint(String endpointUri, NettyHttpComponent component, NettyConfiguration configuration) {
        super(endpointUri, (NettyComponent)component, configuration);
    }

    public NettyHttpComponent getComponent() {
        return (NettyHttpComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        NettyHttpConsumer answer = new NettyHttpConsumer(this, processor, this.getConfiguration());
        this.configureConsumer((Consumer)answer);
        if (this.nettySharedHttpServer != null) {
            answer.setNettyServerBootstrapFactory(this.nettySharedHttpServer.getServerBootstrapFactory());
            LOG.info("NettyHttpConsumer: {} is using NettySharedHttpServer on port: {}", (Object)answer, (Object)this.nettySharedHttpServer.getPort());
        } else {
            HttpServerBootstrapFactory factory = this.getComponent().getOrCreateHttpNettyServerBootstrapFactory(answer);
            answer.setNettyServerBootstrapFactory((NettyServerBootstrapFactory)factory);
            LOG.debug("Created NettyHttpConsumer: {} using HttpServerBootstrapFactory: {}", (Object)answer, (Object)factory);
        }
        return answer;
    }

    public Producer createProducer() throws Exception {
        NettyHttpProducer answer = new NettyHttpProducer(this, this.getConfiguration());
        if (this.isSynchronous()) {
            return new SynchronousDelegateProducer((Producer)answer);
        }
        return answer;
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        throw new UnsupportedOperationException("This component does not support polling consumer");
    }

    public Exchange createExchange(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        Exchange exchange = this.createExchange();
        HttpRequest request = (HttpRequest)messageEvent.getMessage();
        Message in = this.getNettyHttpBinding().toCamelMessage(request, exchange, this.getConfiguration());
        exchange.setIn(in);
        this.updateMessageHeader(in, ctx, messageEvent);
        String contentType = (String)in.getHeader("Content-Type", String.class);
        String charset = NettyHttpHelper.getCharsetFromContentType(contentType);
        if (charset != null) {
            exchange.setProperty("CamelCharsetName", (Object)charset);
            in.setHeader("CamelHttpCharacterEncoding", (Object)charset);
        }
        return exchange;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        super.setConfiguration(configuration);
        this.configuration = (NettyHttpConfiguration)configuration;
    }

    public NettyHttpConfiguration getConfiguration() {
        return (NettyHttpConfiguration)super.getConfiguration();
    }

    public NettyHttpBinding getNettyHttpBinding() {
        return this.nettyHttpBinding;
    }

    public void setNettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
        this.nettyHttpBinding = nettyHttpBinding;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        this.getNettyHttpBinding().setHeaderFilterStrategy(headerFilterStrategy);
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public NettySharedHttpServer getNettySharedHttpServer() {
        return this.nettySharedHttpServer;
    }

    public void setNettySharedHttpServer(NettySharedHttpServer nettySharedHttpServer) {
        this.nettySharedHttpServer = nettySharedHttpServer;
    }

    public NettyHttpSecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(NettyHttpSecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull((Object)this.nettyHttpBinding, (String)"nettyHttpBinding", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.headerFilterStrategy, (String)"headerFilterStrategy", (Object)((Object)this));
        if (this.securityConfiguration != null) {
            ObjectHelper.notEmpty((String)this.securityConfiguration.getRealm(), (String)"realm", (Object)this.securityConfiguration);
            ObjectHelper.notEmpty((String)this.securityConfiguration.getConstraint(), (String)"restricted", (Object)this.securityConfiguration);
            if (this.securityConfiguration.getSecurityAuthenticator() == null) {
                JAASSecurityAuthenticator jaas = new JAASSecurityAuthenticator();
                jaas.setName(this.securityConfiguration.getRealm());
                LOG.info("No SecurityAuthenticator configured, using JAASSecurityAuthenticator as authenticator: {}", (Object)jaas);
                this.securityConfiguration.setSecurityAuthenticator(jaas);
            }
        }
    }
}

