/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.sjms.MessageConsumerResources;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.consumer.AbstractMessageHandler;
import org.apache.camel.component.sjms.consumer.InOnlyMessageHandler;
import org.apache.camel.component.sjms.consumer.InOutMessageHandler;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.JmsObjectFactory;
import org.apache.camel.component.sjms.taskmanager.TimedTaskManager;
import org.apache.camel.component.sjms.tx.BatchTransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.DefaultTransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.SessionBatchTransactionSynchronization;
import org.apache.camel.component.sjms.tx.SessionTransactionSynchronization;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.spi.Synchronization;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class SjmsConsumer
extends DefaultConsumer {
    protected GenericObjectPool<MessageConsumerResources> consumers;
    private ExecutorService executor;
    private Future<?> asyncStart;

    public SjmsConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public SjmsEndpoint getEndpoint() {
        return (SjmsEndpoint)super.getEndpoint();
    }

    protected void startListener() throws Exception {
        this.executor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "SjmsConsumer");
        if (this.consumers == null) {
            this.consumers = new GenericObjectPool((PoolableObjectFactory)new MessageConsumerResourcesFactory());
            this.consumers.setMaxActive(this.getConsumerCount());
            this.consumers.setMaxIdle(this.getConsumerCount());
            if (this.getEndpoint().isAsyncStartListener()) {
                this.asyncStart = this.getEndpoint().getComponent().getAsyncStartStopExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SjmsConsumer.this.fillConsumersPool();
                        }
                        catch (Throwable e) {
                            SjmsConsumer.this.log.warn("Error starting listener container on destination: " + SjmsConsumer.this.getDestinationName() + ". This exception will be ignored.", e);
                        }
                    }

                    public String toString() {
                        return "AsyncStartListenerTask[" + SjmsConsumer.this.getDestinationName() + "]";
                    }
                });
            } else {
                this.fillConsumersPool();
            }
        }
    }

    private void fillConsumersPool() throws Exception {
        while (this.consumers.getNumIdle() < this.consumers.getMaxIdle()) {
            this.consumers.addObject();
        }
    }

    protected void stopListener() throws Exception {
        if (this.asyncStart != null && !this.asyncStart.isDone()) {
            this.asyncStart.cancel(true);
        }
        if (this.consumers != null) {
            if (this.getEndpoint().isAsyncStopListener()) {
                this.getEndpoint().getComponent().getAsyncStartStopExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SjmsConsumer.this.consumers.close();
                            SjmsConsumer.this.consumers = null;
                        }
                        catch (Throwable e) {
                            SjmsConsumer.this.log.warn("Error stopping listener container on destination: " + SjmsConsumer.this.getDestinationName() + ". This exception will be ignored.", e);
                        }
                    }

                    public String toString() {
                        return "AsyncStopListenerTask[" + SjmsConsumer.this.getDestinationName() + "]";
                    }
                });
            } else {
                this.consumers.close();
                this.consumers = null;
            }
        }
        if (this.executor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executor);
            this.executor = null;
        }
    }

    protected void doStart() throws Exception {
        this.startListener();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.stopListener();
        super.doStop();
    }

    protected void doResume() throws Exception {
        this.startListener();
        super.doResume();
    }

    protected void doSuspend() throws Exception {
        this.stopListener();
        super.doSuspend();
    }

    private MessageConsumerResources createConsumer() throws Exception {
        MessageConsumerResources answer;
        Connection conn = this.getConnectionResource().borrowConnection();
        try {
            Session session = conn.createSession(this.isTransacted(), this.isTransacted() ? 0 : 1);
            Destination destination = this.getEndpoint().getDestinationCreationStrategy().createDestination(session, this.getDestinationName(), this.isTopic());
            MessageConsumer messageConsumer = JmsObjectFactory.createMessageConsumer(session, destination, this.getMessageSelector(), this.isTopic(), this.getDurableSubscriptionId());
            MessageListener handler = this.createMessageHandler(session);
            messageConsumer.setMessageListener(handler);
            answer = new MessageConsumerResources(session, messageConsumer);
        }
        catch (Exception e) {
            this.log.error("Unable to create the MessageConsumer", (Throwable)e);
            throw e;
        }
        finally {
            this.getConnectionResource().returnConnection(conn);
        }
        return answer;
    }

    protected MessageListener createMessageHandler(Session session) {
        Object synchronization;
        TransactionCommitStrategy commitStrategy = null;
        commitStrategy = this.getTransactionCommitStrategy() != null ? this.getTransactionCommitStrategy() : (this.getTransactionBatchCount() > 0 ? new BatchTransactionCommitStrategy(this.getTransactionBatchCount()) : new DefaultTransactionCommitStrategy());
        if (commitStrategy instanceof BatchTransactionCommitStrategy) {
            TimedTaskManager timedTaskManager = this.getEndpoint().getComponent().getTimedTaskManager();
            synchronization = new SessionBatchTransactionSynchronization(timedTaskManager, session, commitStrategy, this.getTransactionBatchTimeout());
        } else {
            synchronization = new SessionTransactionSynchronization(session, commitStrategy);
        }
        AbstractMessageHandler messageHandler = this.getEndpoint().getExchangePattern().equals((Object)ExchangePattern.InOnly) ? (this.isTransacted() ? new InOnlyMessageHandler(this.getEndpoint(), this.executor, (Synchronization)synchronization) : new InOnlyMessageHandler(this.getEndpoint(), this.executor)) : (this.isTransacted() ? new InOutMessageHandler(this.getEndpoint(), this.executor, (Synchronization)synchronization) : new InOutMessageHandler(this.getEndpoint(), this.executor));
        messageHandler.setSession(session);
        messageHandler.setProcessor(this.getAsyncProcessor());
        messageHandler.setSynchronous(this.isSynchronous());
        messageHandler.setTransacted(this.isTransacted());
        messageHandler.setTopic(this.isTopic());
        return messageHandler;
    }

    protected ConnectionResource getConnectionResource() {
        return this.getEndpoint().getConnectionResource();
    }

    public int getAcknowledgementMode() {
        return this.getEndpoint().getAcknowledgementMode().intValue();
    }

    public boolean isTransacted() {
        return this.getEndpoint().isTransacted();
    }

    public boolean isSynchronous() {
        return this.getEndpoint().isSynchronous();
    }

    public String getDestinationName() {
        return this.getEndpoint().getDestinationName();
    }

    public int getConsumerCount() {
        return this.getEndpoint().getConsumerCount();
    }

    public boolean isTopic() {
        return this.getEndpoint().isTopic();
    }

    public String getMessageSelector() {
        return this.getEndpoint().getMessageSelector();
    }

    public String getDurableSubscriptionId() {
        return this.getEndpoint().getDurableSubscriptionId();
    }

    public TransactionCommitStrategy getTransactionCommitStrategy() {
        return this.getEndpoint().getTransactionCommitStrategy();
    }

    public int getTransactionBatchCount() {
        return this.getEndpoint().getTransactionBatchCount();
    }

    public long getTransactionBatchTimeout() {
        return this.getEndpoint().getTransactionBatchTimeout();
    }

    protected class MessageConsumerResourcesFactory
    extends BasePoolableObjectFactory<MessageConsumerResources> {
        protected MessageConsumerResourcesFactory() {
        }

        public MessageConsumerResources makeObject() throws Exception {
            return SjmsConsumer.this.createConsumer();
        }

        public void destroyObject(MessageConsumerResources model) throws Exception {
            if (model != null) {
                if (model.getMessageConsumer() != null) {
                    model.getMessageConsumer().close();
                }
                if (model.getSession() != null) {
                    if (model.getSession().getTransacted()) {
                        try {
                            model.getSession().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    model.getSession().close();
                }
            }
        }
    }
}

