/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.Exchange;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.infinispan.commons.api.BasicCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanOperation {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(InfinispanOperation.class);
    private final BasicCache<Object, Object> cache;
    private final InfinispanConfiguration configuration;

    public InfinispanOperation(BasicCache<Object, Object> cache, InfinispanConfiguration configuration) {
        this.cache = cache;
        this.configuration = configuration;
    }

    public void process(Exchange exchange) {
        Operation operation = this.getOperation(exchange);
        operation.execute(this.cache, exchange);
    }

    private Operation getOperation(Exchange exchange) {
        String operation = (String)exchange.getIn().getHeader("CamelInfinispanOperation", String.class);
        if (operation == null) {
            operation = this.configuration.getCommand() != null ? "CamelInfinispanOperation" + this.configuration.getCommand() : "CamelInfinispanOperationPut";
        }
        LOGGER.trace("Operation: [{}]", (Object)operation);
        return Operation.valueOf(operation.substring("CamelInfinispanOperation".length()).toUpperCase());
    }

    static enum Operation {
        PUT{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Object result = cache.put(this.getKey(exchange), this.getValue(exchange));
                this.setResult(result, exchange);
            }
        }
        ,
        GET{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Object result = cache.get(this.getKey(exchange));
                this.setResult(result, exchange);
            }
        }
        ,
        REMOVE{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Object result = cache.remove(this.getKey(exchange));
                this.setResult(result, exchange);
            }
        }
        ,
        CLEAR{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                cache.clear();
            }
        };


        void setResult(Object result, Exchange exchange) {
            exchange.getIn().setHeader("CamelInfinispanOperationResult", result);
        }

        Object getKey(Exchange exchange) {
            return exchange.getIn().getHeader("CamelInfinispanKey");
        }

        Object getValue(Exchange exchange) {
            return exchange.getIn().getHeader("CamelInfinispanValue");
        }

        abstract void execute(BasicCache<Object, Object> var1, Exchange var2);
    }
}

