/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ssh.SshEndpoint;
import org.apache.camel.component.ssh.SshHelper;
import org.apache.camel.component.ssh.SshResult;
import org.apache.camel.impl.DefaultProducer;
import org.apache.sshd.SshClient;

public class SshProducer
extends DefaultProducer {
    private SshEndpoint endpoint;
    private SshClient client;

    public SshProducer(SshEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.client = SshClient.setUpDefaultClient();
        this.client.start();
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.stop();
            this.client = null;
        }
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String command = (String)in.getMandatoryBody(String.class);
        try {
            SshResult result = SshHelper.sendExecCommand(command, this.endpoint, this.client);
            exchange.getOut().setBody((Object)result.getStdout());
            exchange.getOut().setHeader("CamelSshExitValue", (Object)result.getExitValue());
            exchange.getOut().setHeader("CamelSshStderr", (Object)result.getStderr());
        }
        catch (Exception e) {
            throw new CamelExchangeException("Cannot execute command: " + command, exchange, (Throwable)e);
        }
        exchange.getOut().getHeaders().putAll(in.getHeaders());
        exchange.getOut().setAttachments(in.getAttachments());
    }
}

