/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.ssh.SshEndpoint;
import org.apache.camel.component.ssh.SshHelper;
import org.apache.camel.component.ssh.SshResult;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.sshd.SshClient;

public class SshConsumer
extends ScheduledPollConsumer {
    private final SshEndpoint endpoint;
    private SshClient client;

    public SshConsumer(SshEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.client = SshClient.setUpDefaultClient();
        this.client.start();
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.stop();
            this.client = null;
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        String command = this.endpoint.getPollCommand();
        SshResult result = SshHelper.sendExecCommand(command, this.endpoint, this.client);
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setBody((Object)result.getStdout());
        exchange.getIn().setHeader("CamelSshExitValue", (Object)result.getExitValue());
        exchange.getIn().setHeader("CamelSshStderr", (Object)result.getStderr());
        try {
            this.getProcessor().process(exchange);
            int n = 1;
            return n;
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }
}

