/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.krati;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import krati.core.segment.ChannelSegmentFactory;
import krati.core.segment.SegmentFactory;
import krati.io.Serializer;
import krati.store.DataStore;
import krati.util.FnvHashFunction;
import krati.util.HashFunction;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.krati.KratiComponent;
import org.apache.camel.component.krati.KratiConsumer;
import org.apache.camel.component.krati.KratiDataStoreRegistration;
import org.apache.camel.component.krati.KratiHelper;
import org.apache.camel.component.krati.KratiProducer;
import org.apache.camel.component.krati.serializer.KratiDefaultSerializer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="krati", title="Krati", syntax="krati:path", consumerClass=KratiConsumer.class, label="database,nosql")
public class KratiEndpoint
extends ScheduledPollEndpoint {
    protected static Map<String, KratiDataStoreRegistration> dataStoreRegistry = new HashMap<String, KratiDataStoreRegistration>();
    @UriPath
    @Metadata(required="true")
    protected String path;
    @UriParam
    protected String key;
    @UriParam
    protected String value;
    @UriParam
    protected String operation;
    @UriParam(defaultValue="100")
    protected int initialCapacity = 100;
    @UriParam(defaultValue="64")
    protected int segmentFileSize = 64;
    @UriParam
    protected Serializer<Object> keySerializer = new KratiDefaultSerializer<Object>();
    @UriParam
    protected Serializer<Object> valueSerializer = new KratiDefaultSerializer<Object>();
    @UriParam
    protected SegmentFactory segmentFactory = new ChannelSegmentFactory();
    @UriParam
    protected HashFunction<byte[]> hashFunction = new FnvHashFunction();
    @UriParam
    protected int maxMessagesPerPoll;

    public KratiEndpoint(String uri, KratiComponent component) throws URISyntaxException {
        super(uri, (Component)component);
        this.path = this.getPath(uri);
    }

    public void stop() throws Exception {
        super.stop();
        KratiDataStoreRegistration registration = dataStoreRegistry.get(this.path);
        if (registration != null) {
            registration.unregister();
        }
    }

    public Producer createProducer() throws Exception {
        DataStore<Object, Object> dataStore = null;
        KratiDataStoreRegistration registration = dataStoreRegistry.get(this.path);
        if (registration != null) {
            dataStore = registration.getDataStore();
        }
        if (dataStore == null || !dataStore.isOpen()) {
            dataStore = KratiHelper.createDataStore(this.path, this.initialCapacity, this.segmentFileSize, this.segmentFactory, this.hashFunction, this.keySerializer, this.valueSerializer);
            dataStoreRegistry.put(this.path, new KratiDataStoreRegistration(dataStore));
        }
        return new KratiProducer(this, dataStore);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DataStore<Object, Object> dataStore = null;
        KratiDataStoreRegistration registration = dataStoreRegistry.get(this.path);
        if (registration != null) {
            dataStore = registration.getDataStore();
        }
        if (dataStore == null || !dataStore.isOpen()) {
            dataStore = KratiHelper.createDataStore(this.path, this.initialCapacity, this.segmentFileSize, this.segmentFactory, this.hashFunction, this.keySerializer, this.valueSerializer);
            dataStoreRegistry.put(this.path, new KratiDataStoreRegistration(dataStore));
        }
        KratiConsumer answer = new KratiConsumer(this, processor, dataStore);
        answer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isSingleton() {
        return true;
    }

    protected String getPath(String uri) throws URISyntaxException {
        URI u = new URI(uri);
        StringBuilder pathBuilder = new StringBuilder();
        if (u.getHost() != null) {
            pathBuilder.append(u.getHost());
        }
        if (u.getPath() != null) {
            pathBuilder.append(u.getPath());
        }
        return pathBuilder.toString();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public int getSegmentFileSize() {
        return this.segmentFileSize;
    }

    public void setSegmentFileSize(int segmentFileSize) {
        this.segmentFileSize = segmentFileSize;
    }

    public SegmentFactory getSegmentFactory() {
        return this.segmentFactory;
    }

    public void setSegmentFactory(SegmentFactory segmentFactory) {
        this.segmentFactory = segmentFactory;
    }

    public HashFunction<byte[]> getHashFunction() {
        return this.hashFunction;
    }

    public void setHashFunction(HashFunction<byte[]> hashFunction) {
        this.hashFunction = hashFunction;
    }

    public String getPath() {
        return this.path;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }
}

