/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.jsse;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.util.jsse.AbstractJsseParametersTest;
import org.apache.camel.util.jsse.FilterParameters;

public class FilterParametersTest
extends AbstractJsseParametersTest {
    public void testPropertyPlaceholders() throws Exception {
        CamelContext context = this.createPropertiesPlaceholderAwareContext();
        FilterParameters filter = new FilterParameters();
        filter.setCamelContext(context);
        filter.getInclude().add("{{filterParameters.include}}");
        filter.getExclude().add("{{filterParameters.exclude}}");
        FilterParameters.Patterns patterns = filter.getPatterns();
        List includes = patterns.getIncludes();
        List excludes = patterns.getExcludes();
        FilterParametersTest.assertNotNull((Object)includes);
        FilterParametersTest.assertNotNull((Object)excludes);
        FilterParametersTest.assertEquals((int)1, (int)includes.size());
        FilterParametersTest.assertEquals((int)1, (int)excludes.size());
        Matcher includeMatcher = ((Pattern)includes.get(0)).matcher("include");
        FilterParametersTest.assertTrue((boolean)includeMatcher.matches());
        Matcher excludeMatcher = ((Pattern)excludes.get(0)).matcher("exclude");
        FilterParametersTest.assertTrue((boolean)excludeMatcher.matches());
    }

    public void testGetIncludePatterns() {
        FilterParameters filter = new FilterParameters();
        filter.getInclude().add("asdfsadfsadfsadf");
        List includes = filter.getIncludePatterns();
        List excludes = filter.getExcludePatterns();
        FilterParametersTest.assertNotNull((Object)includes);
        FilterParametersTest.assertEquals((int)1, (int)includes.size());
        FilterParametersTest.assertNotNull((Object)excludes);
        FilterParametersTest.assertEquals((int)0, (int)excludes.size());
        FilterParametersTest.assertNotNull(includes.get(0));
        Matcher matcher = ((Pattern)includes.get(0)).matcher("asdfsadfsadfsadf");
        FilterParametersTest.assertTrue((boolean)matcher.matches());
    }

    public void testGetExcludePatterns() {
        FilterParameters filter = new FilterParameters();
        filter.getExclude().add("asdfsadfsadfsadf");
        List includes = filter.getIncludePatterns();
        List excludes = filter.getExcludePatterns();
        FilterParametersTest.assertNotNull((Object)excludes);
        FilterParametersTest.assertEquals((int)1, (int)excludes.size());
        FilterParametersTest.assertNotNull((Object)includes);
        FilterParametersTest.assertEquals((int)0, (int)includes.size());
        FilterParametersTest.assertNotNull(excludes.get(0));
        Matcher matcher = ((Pattern)excludes.get(0)).matcher("asdfsadfsadfsadf");
        FilterParametersTest.assertTrue((boolean)matcher.matches());
    }

    public void test() {
        FilterParameters filter = new FilterParameters();
        filter.getInclude().add("asdf.*");
        filter.getExclude().add("aa");
        FilterParameters.Patterns patterns = filter.getPatterns();
        List includes = patterns.getIncludes();
        List excludes = patterns.getExcludes();
        FilterParametersTest.assertNotNull((Object)includes);
        FilterParametersTest.assertNotNull((Object)excludes);
        FilterParametersTest.assertEquals((int)1, (int)includes.size());
        FilterParametersTest.assertEquals((int)1, (int)excludes.size());
        Matcher includeMatcher = ((Pattern)includes.get(0)).matcher("asdfsadfsadfsadf");
        FilterParametersTest.assertTrue((boolean)includeMatcher.matches());
        Matcher excludeMatcher = ((Pattern)excludes.get(0)).matcher("aa");
        FilterParametersTest.assertTrue((boolean)excludeMatcher.matches());
    }
}

