/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.camel.util.concurrent.SubmitOrderedCompletionService;

public class SubmitOrderedCompletionServiceTest
extends TestCase {
    private ExecutorService executor;
    private SubmitOrderedCompletionService<Object> service;

    protected void setUp() throws Exception {
        this.executor = Executors.newFixedThreadPool(5);
        this.service = new SubmitOrderedCompletionService((Executor)this.executor);
    }

    protected void tearDown() throws Exception {
        this.executor.shutdownNow();
    }

    public void testSubmitOrdered() throws Exception {
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return "A";
            }
        });
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return "B";
            }
        });
        Object a = this.service.take().get();
        Object b = this.service.take().get();
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"A", a);
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"B", b);
    }

    public void testSubmitOrderedFirstTaskIsSlow() throws Exception {
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Thread.sleep(200L);
                return "A";
            }
        });
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return "B";
            }
        });
        Object a = this.service.take().get();
        Object b = this.service.take().get();
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"A", a);
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"B", b);
    }

    public void testSubmitOrderedFirstTaskIsSlowUsingPollTimeout() throws Exception {
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Thread.sleep(200L);
                return "A";
            }
        });
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return "B";
            }
        });
        Object a = this.service.poll(5L, TimeUnit.SECONDS).get();
        Object b = this.service.poll(5L, TimeUnit.SECONDS).get();
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"A", a);
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"B", b);
    }

    public void testSubmitOrderedFirstTaskIsSlowUsingPoll() throws Exception {
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Thread.sleep(1000L);
                return "A";
            }
        });
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return "B";
            }
        });
        Future a = this.service.poll();
        SubmitOrderedCompletionServiceTest.assertNull((Object)a);
        Thread.sleep(100L);
        a = this.service.poll();
        SubmitOrderedCompletionServiceTest.assertNull((Object)a);
        a = this.service.take().get();
        Object b = this.service.take().get();
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"A", (Object)a);
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"B", b);
    }

    public void testSubmitOrderedSecondTaskIsSlow() throws Exception {
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return "A";
            }
        });
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Thread.sleep(200L);
                return "B";
            }
        });
        Object a = this.service.take().get();
        Object b = this.service.take().get();
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"A", a);
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"B", b);
    }

    public void testSubmitOrderedSecondTaskIsSlowUsingPollTimeout() throws Exception {
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return "A";
            }
        });
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Thread.sleep(200L);
                return "B";
            }
        });
        Object a = this.service.poll(5L, TimeUnit.SECONDS).get();
        Object b = this.service.poll(5L, TimeUnit.SECONDS).get();
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"A", a);
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"B", b);
    }

    public void testSubmitOrderedLastTaskIsSlowUsingPoll() throws Exception {
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return "A";
            }
        });
        this.service.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Thread.sleep(1000L);
                return "B";
            }
        });
        Object a = this.service.take().get();
        SubmitOrderedCompletionServiceTest.assertNotNull(a);
        Future b = this.service.poll();
        SubmitOrderedCompletionServiceTest.assertNull((Object)b);
        Thread.sleep(100L);
        b = this.service.poll();
        SubmitOrderedCompletionServiceTest.assertNull((Object)b);
        b = this.service.take().get();
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"A", a);
        SubmitOrderedCompletionServiceTest.assertEquals((Object)"B", (Object)b);
    }
}

