/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.MessageDump;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ValueHolder;

public class MessageHelperTest
extends TestCase {
    private Message message;

    protected void setUp() throws Exception {
        this.message = new DefaultMessage();
    }

    public void testResetStreamCache() throws Exception {
        MessageHelper.resetStreamCache(null);
        MessageHelper.resetStreamCache((Message)this.message);
        final ValueHolder reset = new ValueHolder((Object)Boolean.FALSE);
        this.message.setBody((Object)new StreamCache(){

            public void reset() {
                reset.set((Object)Boolean.TRUE);
            }

            public void writeTo(OutputStream os) throws IOException {
            }

            public StreamCache copy() throws IOException {
                return null;
            }

            public boolean inMemory() {
                return true;
            }

            public long length() {
                return 0L;
            }
        });
        MessageHelper.resetStreamCache((Message)this.message);
        MessageHelperTest.assertTrue((String)"Should have reset the stream cache", (boolean)((Boolean)reset.get()));
    }

    public void testGetContentType() throws Exception {
        this.message.setHeader("Content-Type", (Object)"text/xml");
        MessageHelperTest.assertEquals((String)"text/xml", (String)MessageHelper.getContentType((Message)this.message));
    }

    public void testGetContentEncpding() throws Exception {
        this.message.setHeader("Content-Encoding", (Object)"iso-8859-1");
        MessageHelperTest.assertEquals((String)"iso-8859-1", (String)MessageHelper.getContentEncoding((Message)this.message));
    }

    public void testCopyHeaders() throws Exception {
        Message source = this.message;
        DefaultMessage target = new DefaultMessage();
        source.setHeader("foo", (Object)123);
        source.setHeader("bar", (Object)456);
        target.setHeader("bar", (Object)"yes");
        MessageHelper.copyHeaders((Message)source, (Message)target, (boolean)false);
        MessageHelperTest.assertEquals((Object)123, (Object)target.getHeader("foo"));
        MessageHelperTest.assertEquals((Object)"yes", (Object)target.getHeader("bar"));
    }

    public void testCopyHeadersOverride() throws Exception {
        Message source = this.message;
        DefaultMessage target = new DefaultMessage();
        source.setHeader("foo", (Object)123);
        source.setHeader("bar", (Object)456);
        target.setHeader("bar", (Object)"yes");
        MessageHelper.copyHeaders((Message)source, (Message)target, (boolean)true);
        MessageHelperTest.assertEquals((Object)123, (Object)target.getHeader("foo"));
        MessageHelperTest.assertEquals((Object)456, (Object)target.getHeader("bar"));
    }

    public void testCopyHeadersWithHeaderFilterStrategy() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        Message source = this.message = new DefaultExchange((CamelContext)context).getIn();
        Message target = this.message.getExchange().getOut();
        DefaultHeaderFilterStrategy headerFilterStrategy = new DefaultHeaderFilterStrategy();
        headerFilterStrategy.setInFilterPattern("foo");
        source.setHeader("foo", (Object)123);
        source.setHeader("bar", (Object)456);
        target.setHeader("bar", (Object)"yes");
        MessageHelper.copyHeaders((Message)source, (Message)target, (HeaderFilterStrategy)headerFilterStrategy, (boolean)true);
        MessageHelperTest.assertEquals(null, (Object)target.getHeader("foo"));
        MessageHelperTest.assertEquals((Object)456, (Object)target.getHeader("bar"));
        context.stop();
    }

    public void testDumpAsXmlPlainBody() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"Hello World");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsXml((Message)this.message);
        MessageHelperTest.assertTrue((String)"Should contain body", (boolean)out.contains("<body type=\"java.lang.String\">Hello World</body>"));
        context.stop();
    }

    public void testDumpAsXmlBody() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"<?xml version=\"1.0\"?><hi>Hello World</hi>");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsXml((Message)this.message);
        MessageHelperTest.assertTrue((String)"Should contain body", (boolean)out.contains("<body type=\"java.lang.String\">&lt;?xml version=&quot;1.0&quot;?&gt;&lt;hi&gt;Hello World&lt;/hi&gt;</body>"));
        MessageHelperTest.assertTrue((String)"Should contain exchangeId", (boolean)out.contains(this.message.getExchange().getExchangeId()));
        context.stop();
    }

    public void testDumpAsXmlNoBody() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"Hello World");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsXml((Message)this.message, (boolean)false);
        MessageHelperTest.assertEquals((String)("<message exchangeId=\"" + this.message.getExchange().getExchangeId() + "\">" + "\n  <headers>\n    <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n  </headers>\n</message>"), (String)out);
        context.stop();
    }

    public void testDumpAsXmlNoBodyIndent() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"Hello World");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsXml((Message)this.message, (boolean)false, (int)2);
        MessageHelperTest.assertEquals((String)("  <message exchangeId=\"" + this.message.getExchange().getExchangeId() + "\">" + "\n    <headers>\n      <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n    </headers>\n  </message>"), (String)out);
        context.stop();
    }

    public void testMessageDump() throws Exception {
        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{MessageDump.class});
        Unmarshaller unmarshaller = jaxb.createUnmarshaller();
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"Hello World");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsXml((Message)this.message, (boolean)true);
        MessageDump dump = (MessageDump)unmarshaller.unmarshal((Reader)new StringReader(out));
        MessageHelperTest.assertNotNull((Object)dump);
        MessageHelperTest.assertEquals((String)"java.lang.String", (String)dump.getBody().getType());
        MessageHelperTest.assertEquals((String)"Hello World", (String)dump.getBody().getValue());
        MessageHelperTest.assertEquals((int)1, (int)dump.getHeaders().size());
        MessageHelperTest.assertEquals((String)"foo", (String)((MessageDump.Header)dump.getHeaders().get(0)).getKey());
        MessageHelperTest.assertEquals((String)"java.lang.Integer", (String)((MessageDump.Header)dump.getHeaders().get(0)).getType());
        MessageHelperTest.assertEquals((String)"123", (String)((MessageDump.Header)dump.getHeaders().get(0)).getValue());
    }
}

