/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import junit.framework.TestCase;
import org.apache.camel.util.AntPathMatcher;

public class AntPathMatcherTest
extends TestCase {
    public void test() {
        AntPathMatcher matcher = new AntPathMatcher();
        AntPathMatcherTest.assertTrue((boolean)matcher.match("*.txt", "blah.txt"));
        AntPathMatcherTest.assertFalse((boolean)matcher.match("*.txt", "foo/blah.txt"));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("???.txt", "abc.txt"));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("abc.t?t", "abc.tnt"));
        AntPathMatcherTest.assertFalse((boolean)matcher.match("???.txt", "abcd.txt"));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("**/*.txt", "blah.txt"));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("**/*.txt", "foo/blah.txt"));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("**/*.txt", "foo/bar/blah.txt"));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("foo/**/*.txt", "foo/bar/blah.txt"));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("foo/**/*.??", "foo/bar/blah.gz"));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("foo/**/*.txt", "foo/blah.txt"));
        AntPathMatcherTest.assertFalse((boolean)matcher.match("foo/**/*.txt", "blah/blah.txt"));
    }

    public void testCaseSensitive() {
        AntPathMatcher matcher = new AntPathMatcher();
        AntPathMatcherTest.assertTrue((boolean)matcher.match("foo/**/*.txt", "foo/blah.txt", true));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("foo/**/*.txt", "foo/blah.txt", false));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("foo/**/*.txt", "foo/BLAH.txt"));
        AntPathMatcherTest.assertFalse((boolean)matcher.match("FOO/**/*.txt", "foo/blah.txt"));
        AntPathMatcherTest.assertFalse((boolean)matcher.match("foo/**/*.TXT", "foo/blah.txt"));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("foo/**/*.TXT", "foo/blah.txt", false));
        AntPathMatcherTest.assertTrue((boolean)matcher.match("FOO/**/*.txt", "foo/blah.txt", false));
        AntPathMatcherTest.assertFalse((boolean)matcher.match("FOO/**/*.txt", "foo/blah.txt", true));
        AntPathMatcherTest.assertFalse((boolean)matcher.match("FOO/**/*.txt", "foo/blah.txt", true));
    }
}

