/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Container;

public class ContainerTest
extends TestCase {
    protected void tearDown() throws Exception {
        Container.Instance.set(null);
        super.tearDown();
    }

    public void testContainerSet() throws Exception {
        MyContainer myContainer = new MyContainer();
        DefaultCamelContext camel1 = new DefaultCamelContext();
        DefaultCamelContext camel2 = new DefaultCamelContext();
        ContainerTest.assertEquals((int)0, (int)myContainer.names.size());
        Container.Instance.set((Container)myContainer);
        ContainerTest.assertEquals((int)2, (int)myContainer.names.size());
        DefaultCamelContext camel3 = new DefaultCamelContext();
        ContainerTest.assertEquals((int)3, (int)myContainer.names.size());
        ContainerTest.assertEquals((String)camel1.getName(), (String)((String)myContainer.names.get(0)));
        ContainerTest.assertEquals((String)camel2.getName(), (String)((String)myContainer.names.get(1)));
        ContainerTest.assertEquals((String)camel3.getName(), (String)((String)myContainer.names.get(2)));
        camel1.stop();
        camel2.stop();
        camel3.stop();
    }

    public void testNoContainerSet() throws Exception {
        MyContainer myContainer = new MyContainer();
        DefaultCamelContext camel1 = new DefaultCamelContext();
        DefaultCamelContext camel2 = new DefaultCamelContext();
        ContainerTest.assertEquals((int)0, (int)myContainer.names.size());
        camel1.stop();
        camel2.stop();
    }

    private final class MyContainer
    implements Container {
        private List<String> names = new ArrayList<String>();

        private MyContainer() {
        }

        public void manage(CamelContext camelContext) {
            this.names.add(camelContext.getName());
        }
    }
}

