/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class RoutingSlipIgnoreInvalidEndpointsTest
extends ContextTestSupport {
    public void testEndpointResolvedFailedWithIgnoreInvalidEndpoints() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello", "myHeader", (Object)"direct:start ,fail:endpoint, mock:result");
        this.assertMockEndpointsSatisfied();
    }

    public void testEndpointResolvedFailedWithoutIgnoreInvalidEndpoints() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(0);
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:b", (Object)"Hello", "myHeader", (Object)"direct:start,fail:endpoint,mock:result");
            RoutingSlipIgnoreInvalidEndpointsTest.fail((String)"Expect the exception here.");
        }
        catch (Exception ex) {
            RoutingSlipIgnoreInvalidEndpointsTest.assertTrue((String)"Get a wrong cause of the exception", (boolean)(ex.getCause() instanceof ResolveEndpointFailedException));
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").routingSlip((Expression)this.header("myHeader")).ignoreInvalidEndpoints().to("mock:end");
                this.from("direct:b").routingSlip((Expression)this.header("myHeader")).to("mock:end");
                this.from("direct:start").transform((Expression)this.constant("Hello World"));
            }
        };
    }
}

