/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;

public class OnExceptionHandledTest
extends ContextTestSupport {
    public void testHandled() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:handled");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)mock.message(0).exchangeProperty("CamelExceptionCaught")).isNotNull();
        ((ValueBuilder)mock.message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        ((ValueBuilder)mock.message(0).exchangeProperty("CamelExceptionCaught")).method("getMessage").isEqualTo((Object)"Forced");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(IllegalArgumentException.class).handled(true).to("log:foo?showAll=true")).to("mock:handled");
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

