/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptDefinition;

public class InterceptFromWhenTest
extends ContextTestSupport {
    public void testInterceptorWhen() throws Exception {
        this.getMockEndpoint("mock:goofy").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.sendBody("direct:start", "Hello World!");
        this.assertMockEndpointsSatisfied();
    }

    public void testInterceptorWhenGoofy() throws Exception {
        this.getMockEndpoint("mock:goofy").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.sendBody("direct:start", "Hello Goofy");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                InterceptFromWhenTest.this.context.setTracing(Boolean.valueOf(true));
                ((InterceptDefinition)this.interceptFrom().when((Predicate)this.simple("${body} contains 'Goofy'")).to("mock:goofy")).stop();
                this.from("direct:start").to("mock:end");
            }
        };
    }
}

