/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;

public class InterceptFromWhenNoStopTest
extends ContextTestSupport {
    public void testInterceptorWhen() throws Exception {
        this.getMockEndpoint("mock:goofy").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.sendBody("direct:start", "Hello World!");
        this.assertMockEndpointsSatisfied();
    }

    public void testInterceptorWhenGoofy() throws Exception {
        this.getMockEndpoint("mock:goofy").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.sendBody("direct:start", "Hello Goofy");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptFrom().when((Predicate)this.simple("${body} contains 'Goofy'")).to("mock:goofy");
                this.from("direct:start").to("mock:end");
            }
        };
    }
}

