/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;

public class InterceptFromPropertyPlaceholderTest
extends ContextTestSupport {
    public void testInterceptFrom() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptFrom("seda:foo").to("mock:foo");
                this.from("seda:{{queue}}").to("mock:result");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("classpath:org/apache/camel/processor/intercept/myproperties.properties");
        context.addComponent("properties", (Component)pc);
        return context;
    }
}

