/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FromFileInterceptSendToIssue
extends ContextTestSupport {
    public void testInterceptSendTo() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelInterceptedEndpoint", (Object)"direct://foo");
        this.template.sendBodyAndHeader("file://target/intercept", (Object)"Hello World", "CamelFileName", (Object)"input.txt");
        this.assertMockEndpointsSatisfied();
        Exchange exchange = (Exchange)mock.getReceivedExchanges().get(0);
        FromFileInterceptSendToIssue.assertEquals((String)"file://target/intercept", (String)exchange.getFromEndpoint().getEndpointUri());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("direct:foo").to("mock:foo");
                ((RouteDefinition)this.from("file://target/intercept").setHeader("CamelFileName", (Expression)this.constant("hello.txt"))).to("direct:foo");
            }
        };
    }
}

