/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;

public class PollEnricherRefTest
extends ContextTestSupport {
    private SedaEndpoint cool = new SedaEndpoint();

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("cool", (Object)this.cool);
        jndi.bind("agg", (Object)new UseLatestAggregationStrategy());
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        this.cool.setCamelContext(context);
        return context;
    }

    public void testPollEnrichRef() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Bye World");
        this.cool.getQueue().add(exchange);
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        PollEnricherRefTest.assertEquals((String)"Bye World", (String)out);
        PollEnricherRefTest.assertEquals((int)0, (int)this.cool.getQueue().size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                PollEnricherRefTest.this.cool.setEndpointUriIfNotSpecified("cool");
                this.from("direct:start").pollEnrichRef("cool", 2000L, "agg");
            }
        };
    }
}

