/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointRecipientListParallel5Test
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointRecipientListParallel5Test.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncEndpointRecipientListParallel5Test.assertTrue((String)"Should use same threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointRecipientListParallel5Test.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).recipientList((Expression)this.constant("async:hi:camel,async:hi:world,direct:foo")).parallelProcessing().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after")).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").transform((Expression)this.constant("Bye Camel"))).to("mock:foo");
            }
        };
    }
}

