/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import junit.framework.TestCase;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;

public class OptimisticLockRetryPolicyTest
extends TestCase {
    private static long precision = 100L;

    public void testRandomBackOff() throws Exception {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(true);
        policy.setExponentialBackOff(false);
        policy.setMaximumRetryDelay(500L);
        for (int i = 0; i < 10; ++i) {
            long elapsed = this.doDelay(policy, i);
            OptimisticLockRetryPolicyTest.assertTrue((elapsed <= policy.getMaximumRetryDelay() + precision && elapsed >= 0L ? 1 : 0) != 0);
        }
    }

    public void testExponentialBackOff() throws Exception {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(true);
        policy.setMaximumRetryDelay(0L);
        policy.setRetryDelay(50L);
        for (int i = 0; i < 6; ++i) {
            long elapsed = this.doDelay(policy, i);
            this.assertDelay(50L << i, elapsed);
        }
    }

    public void testExponentialBackOffMaximumRetryDelay() throws Exception {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(true);
        policy.setMaximumRetryDelay(200L);
        policy.setRetryDelay(50L);
        block4: for (int i = 0; i < 10; ++i) {
            long elapsed = this.doDelay(policy, i);
            switch (i) {
                case 0: {
                    this.assertDelay(50L, elapsed);
                    continue block4;
                }
                case 1: {
                    this.assertDelay(100L, elapsed);
                    continue block4;
                }
                default: {
                    this.assertDelay(200L, elapsed);
                }
            }
        }
    }

    public void testRetryDelay() throws Exception {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(false);
        policy.setMaximumRetryDelay(0L);
        policy.setRetryDelay(50L);
        for (int i = 0; i < 10; ++i) {
            long elapsed = this.doDelay(policy, i);
            this.assertDelay(50L, elapsed);
        }
    }

    public void testMaximumRetries() throws Exception {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        policy.setRandomBackOff(false);
        policy.setExponentialBackOff(false);
        policy.setMaximumRetryDelay(0L);
        policy.setMaximumRetries(2);
        policy.setRetryDelay(50L);
        block3: for (int i = 0; i < 10; ++i) {
            switch (i) {
                case 0: 
                case 1: {
                    OptimisticLockRetryPolicyTest.assertTrue((boolean)policy.shouldRetry(i));
                    continue block3;
                }
                default: {
                    OptimisticLockRetryPolicyTest.assertFalse((boolean)policy.shouldRetry(i));
                }
            }
        }
    }

    private long doDelay(OptimisticLockRetryPolicy policy, int i) throws InterruptedException {
        long start = System.currentTimeMillis();
        policy.doDelay(i);
        long elapsed = System.currentTimeMillis() - start;
        return elapsed;
    }

    private void assertDelay(long expectedDelay, long actualDelay) {
        String msg = String.format("%d <= %d", actualDelay, expectedDelay + precision);
        OptimisticLockRetryPolicyTest.assertTrue((String)msg, (actualDelay <= expectedDelay + precision ? 1 : 0) != 0);
        msg = String.format("%d >= %d", actualDelay, expectedDelay - precision);
        OptimisticLockRetryPolicyTest.assertTrue((String)msg, (actualDelay >= expectedDelay - precision ? 1 : 0) != 0);
    }
}

