/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class AggregateIgnoreInvalidCorrelationKeysTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testAggregateIgnoreInvalidCorrelationKeys() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(2).ignoreInvalidCorrelationKeys().to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A+C"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", null);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    public void testAggregateNotIgnoreInvalidCorrelationKeys() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(2).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A+C"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)1);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", null);
            AggregateIgnoreInvalidCorrelationKeysTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            CamelExchangeException cause = AggregateIgnoreInvalidCorrelationKeysTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            AggregateIgnoreInvalidCorrelationKeysTest.assertEquals((String)"Invalid correlation key. Exchange[Message: B]", (String)cause.getMessage());
        }
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }
}

