/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.ClosedCorrelationKeyException;

public class AggregateClosedCorrelationKeyTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testAggregateClosedCorrelationKey() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(2).closeCorrelationKeyOnCompletion(1000).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A+B"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)1);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)1);
            AggregateClosedCorrelationKeyTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            ClosedCorrelationKeyException cause = AggregateClosedCorrelationKeyTest.assertIsInstanceOf(ClosedCorrelationKeyException.class, e.getCause());
            AggregateClosedCorrelationKeyTest.assertEquals((String)"1", (String)cause.getCorrelationKey());
            AggregateClosedCorrelationKeyTest.assertEquals((String)"The correlation key [1] has been closed. Exchange[Message: C]", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testAggregateClosedCorrelationKeyCache() throws Exception {
        ClosedCorrelationKeyException cause;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(2).closeCorrelationKeyOnCompletion(2).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"A+B", "C+D", "E+F"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"D", "id", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"E", "id", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"F", "id", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"G", "id", (Object)1);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"H", "id", (Object)2);
            AggregateClosedCorrelationKeyTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            cause = AggregateClosedCorrelationKeyTest.assertIsInstanceOf(ClosedCorrelationKeyException.class, e.getCause());
            AggregateClosedCorrelationKeyTest.assertEquals((String)"2", (String)cause.getCorrelationKey());
            AggregateClosedCorrelationKeyTest.assertEquals((String)"The correlation key [2] has been closed. Exchange[Message: H]", (String)cause.getMessage());
        }
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"I", "id", (Object)3);
            AggregateClosedCorrelationKeyTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            cause = AggregateClosedCorrelationKeyTest.assertIsInstanceOf(ClosedCorrelationKeyException.class, e.getCause());
            AggregateClosedCorrelationKeyTest.assertEquals((String)"3", (String)cause.getCorrelationKey());
            AggregateClosedCorrelationKeyTest.assertEquals((String)"The correlation key [3] has been closed. Exchange[Message: I]", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }
}

