/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ThreadPoolProfileBuilder;

public class ThrottlerAsyncDelayedCallerRunsTest
extends ContextTestSupport {
    public void testThrottler() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(6);
        this.template.sendBody("seda:start", (Object)"A");
        this.template.sendBody("seda:start", (Object)"B");
        this.template.sendBody("seda:start", (Object)"C");
        this.template.sendBody("seda:start", (Object)"D");
        this.template.sendBody("seda:start", (Object)"E");
        this.template.sendBody("seda:start", (Object)"F");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ThreadPoolProfileBuilder builder = new ThreadPoolProfileBuilder("myThrottler");
                builder.maxQueueSize(Integer.valueOf(2));
                ThrottlerAsyncDelayedCallerRunsTest.this.context.getExecutorServiceManager().registerThreadPoolProfile(builder.build());
                this.from("seda:start").throttle(1L).timePeriodMillis(100L).asyncDelayed().executorServiceRef("myThrottler").callerRunsWhenRejected(true).to("mock:result");
            }
        };
    }
}

