/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.RouteDefinition;

public class SendExchangePatternOptionTest
extends ContextTestSupport {
    public void testExchangePatternOptionInOnly() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        this.getMockEndpoint("mock:stub").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:stub").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testExchangePatternOptionInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOut);
        this.getMockEndpoint("mock:stub").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:stub").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        this.template.requestBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("stub:foo?exchangePattern=InOnly")).to("mock:result");
                this.from("stub:foo").to("mock:stub");
            }
        };
    }
}

