/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RecipientList;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class RecipientListBeanSubUnitOfWorkTest
extends ContextTestSupport {
    private static int counter;

    public void testOK() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"direct:a,direct:b");
        this.assertMockEndpointsSatisfied();
    }

    public void testError() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Donkey was here"});
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)"direct:a,direct:b");
        this.assertMockEndpointsSatisfied();
        RecipientListBeanSubUnitOfWorkTest.assertEquals((int)4, (int)counter);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").useOriginalMessage().maximumRedeliveries(3).redeliveryDelay(0L));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:start")).process((Processor)new MyPreProcessor())).bean(WhereToGoBean.class)).to("mock:result");
                this.from("direct:a").to("mock:a");
                ((RouteDefinition)this.from("direct:b").process((Processor)new MyProcessor())).to("mock:b");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if (body.contains("Donkey")) {
                counter++;
                throw new IllegalArgumentException("Donkey not allowed");
            }
        }
    }

    public static class MyPreProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if (body.startsWith("Bye")) {
                exchange.getIn().setBody((Object)"Donkey was here");
            }
        }
    }

    public static class WhereToGoBean {
        @RecipientList(shareUnitOfWork=true)
        public String whereToGo() {
            return "direct:a,direct:b";
        }
    }
}

