/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;

public class ProcessorMutateExchangeRedeliverTest
extends ContextTestSupport {
    private static int counter;

    public void testRedeliverA() throws Exception {
        counter = 0;
        try {
            this.template.sendBody("direct:a", (Object)"Hello World");
            ProcessorMutateExchangeRedeliverTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            ProcessorMutateExchangeRedeliverTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        ProcessorMutateExchangeRedeliverTest.assertEquals((int)4, (int)counter);
    }

    public void testRedeliverB() throws Exception {
        counter = 0;
        try {
            this.template.sendBody("direct:b", (Object)"Hello World");
            ProcessorMutateExchangeRedeliverTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            ProcessorMutateExchangeRedeliverTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        ProcessorMutateExchangeRedeliverTest.assertEquals((int)4, (int)counter);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(3).redeliveryDelay(0L));
                this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                        TestCase.assertFalse((String)"Should not have OUT", (boolean)exchange.hasOut());
                        TestCase.assertNull((Object)exchange.getException());
                        exchange.getIn().setBody((Object)"Bye World");
                        counter++;
                        throw new IllegalArgumentException("Forced");
                    }
                });
                this.from("direct:b").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                        TestCase.assertFalse((String)"Should not have OUT", (boolean)exchange.hasOut());
                        TestCase.assertNull((Object)exchange.getException());
                        exchange.getOut().setBody((Object)"Bye World");
                        counter++;
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }
}

