/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnCompletionDefinition;

public class OnCompletionModeTest
extends ContextTestSupport {
    public void testOnCompletionScopeBefore() throws Exception {
        this.getMockEndpoint("mock:input").expectedBodiesReceived(new Object[]{"Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"I was here Hello Camel"});
        String out = (String)this.template.requestBody("seda:foo", (Object)"Camel", String.class);
        OnCompletionModeTest.assertEquals((String)"I was here Hello Camel", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testOnCompletionScopeAfter() throws Exception {
        this.getMockEndpoint("mock:input").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"I was here Hello World"});
        String out = (String)this.template.requestBody("seda:bar", (Object)"World", String.class);
        OnCompletionModeTest.assertEquals((String)"Hello World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnCompletionDefinition)((OnCompletionDefinition)this.from("seda:foo").onCompletion().modeBeforeConsumer().transform((Expression)this.body().prepend((Object)"I was here "))).to("mock:after")).end().to("mock:input").transform((Expression)this.body().prepend((Object)"Hello ")).to("log:foo");
                ((OnCompletionDefinition)((OnCompletionDefinition)this.from("seda:bar").onCompletion().modeAfterConsumer().parallelProcessing().transform((Expression)this.body().prepend((Object)"I was here "))).to("mock:after")).end().to("mock:input").transform((Expression)this.body().prepend((Object)"Hello ")).to("log:bar");
            }
        };
    }
}

