/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;

public class IdempotentConsumerRemoveOnFailureTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    public void testFailedExchangesNotRemoved() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), MemoryIdempotentRepository.memoryIdempotentRepository((int)200)).removeOnFailure(false).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String id = (String)exchange.getIn().getHeader("messageId", String.class);
                        if (id.equals("2")) {
                            throw new IllegalArgumentException("Damn I cannot handle id 2");
                        }
                    }
                })).to("mock:result");
            }
        };
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }
}

