/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;

public class FilterNotMatchedTest
extends ContextTestSupport {
    public void testSendMatchingMessage() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).exchangeProperty("CamelFilterMatched")).isEqualTo((Object)true);
        ((ValueBuilder)this.getMockEndpoint("mock:end").message(0).exchangeProperty("CamelFilterMatched")).isNotNull();
        ((ValueBuilder)this.getMockEndpoint("mock:end").message(0).exchangeProperty("CamelFilterMatched")).isEqualTo((Object)true);
        this.template.sendBodyAndHeader("direct:start", (Object)"<matched/>", "foo", (Object)"bar");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendNotMatchingMessage() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        ((ValueBuilder)this.getMockEndpoint("mock:end").message(0).exchangeProperty("CamelFilterMatched")).isNotNull();
        ((ValueBuilder)this.getMockEndpoint("mock:end").message(0).exchangeProperty("CamelFilterMatched")).isEqualTo((Object)false);
        this.template.sendBodyAndHeader("direct:start", (Object)"<notMatched/>", "foo", (Object)"notMatchedHeaderValue");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").filter(this.header("foo").isEqualTo((Object)"bar")).to("mock:result")).end().to("mock:end");
            }
        };
    }
}

