/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.net.SocketException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FailOverAllFailedExceptionTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().failover(2, false, true, new Class[0]).to(new String[]{"direct:x", "direct:y", "direct:z"});
                ((RouteDefinition)this.from("direct:x").to("mock:x")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new SocketException("Forced");
                    }
                });
                ((RouteDefinition)this.from("direct:y").to("mock:y")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Illegal");
                    }
                });
                ((RouteDefinition)this.from("direct:z").to("mock:z")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new SocketException("Not Again");
                    }
                });
            }
        };
    }

    public void testAllFailed() throws Exception {
        this.x.expectedMessageCount(1);
        this.y.expectedMessageCount(1);
        this.z.expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            FailOverAllFailedExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            FailOverAllFailedExceptionTest.assertEquals((String)"Not Again", (String)e.getCause().getMessage());
            FailOverAllFailedExceptionTest.assertIsInstanceOf(SocketException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }
}

