/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;

public class DoubleLoadBalancerMisconfigurationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testMisconfiguration() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").loadBalance().failover().roundRobin().to(new String[]{"mock:a", "mock:b"});
                }
            });
            DoubleLoadBalancerMisconfigurationTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            DoubleLoadBalancerMisconfigurationTest.assertEquals((String)"Loadbalancer already configured to: FailoverLoadBalancer. Cannot set it to: RoundRobinLoadBalancer", (String)e.getMessage());
        }
    }

    public void testMisconfiguration2() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").loadBalance().failover().random().to(new String[]{"mock:a", "mock:b"});
                }
            });
            DoubleLoadBalancerMisconfigurationTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            DoubleLoadBalancerMisconfigurationTest.assertEquals((String)"Loadbalancer already configured to: FailoverLoadBalancer. Cannot set it to: RandomLoadBalancer", (String)e.getMessage());
        }
    }

    public void testMisconfiguration3() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").loadBalance().random().failover().to(new String[]{"mock:a", "mock:b"});
                }
            });
            DoubleLoadBalancerMisconfigurationTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException e) {
            DoubleLoadBalancerMisconfigurationTest.assertEquals((String)"Loadbalancer already configured to: RandomLoadBalancer. Cannot set it to: FailoverLoadBalancer", (String)e.getMessage());
        }
    }
}

