/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DefaultConsumerBridgeErrorHandlerTest
extends ContextTestSupport {
    protected final CountDownLatch latch = new CountDownLatch(1);

    public void testDefaultConsumerBridgeErrorHandler() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World", "Hello World"});
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Cannot process"});
        this.latch.countDown();
        this.assertMockEndpointsSatisfied();
        Exception cause = (Exception)((Exchange)this.getMockEndpoint("mock:dead").getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        DefaultConsumerBridgeErrorHandlerTest.assertNotNull((Object)cause);
        DefaultConsumerBridgeErrorHandlerTest.assertEquals((String)"Simulated", (String)cause.getMessage());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().addComponent("my", (Component)new MyComponent());
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)this.from("my:foo?consumer.bridgeErrorHandler=true").to("log:foo")).to("mock:result");
            }
        };
    }

    public class MyConsumer
    extends DefaultConsumer {
        private int invoked;

        public MyConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }

        public void doSomething() throws Exception {
            try {
                if (this.invoked++ == 0) {
                    throw new IllegalArgumentException("Simulated");
                }
                Exchange exchange = this.getEndpoint().createExchange();
                exchange.getIn().setBody((Object)"Hello World");
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException("Cannot process", (Throwable)e);
            }
        }

        protected void doStart() throws Exception {
            super.doStart();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        DefaultConsumerBridgeErrorHandlerTest.this.latch.await(5L, TimeUnit.SECONDS);
                        MyConsumer.this.doSomething();
                        MyConsumer.this.doSomething();
                        MyConsumer.this.doSomething();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        }
    }

    public class MyEndpoint
    extends DefaultEndpoint {
        public MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public Producer createProducer() throws Exception {
            return null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            MyConsumer answer = new MyConsumer((Endpoint)this, processor);
            this.configureConsumer((Consumer)answer);
            return answer;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    public class MyComponent
    extends DefaultComponent {
        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return new MyEndpoint(uri, (Component)this);
        }
    }
}

