/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class DeadLetterChannelNoRedeliveryTest
extends ContextTestSupport {
    private static volatile int counter;

    public void testDLCNoRedelivery() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DeadLetterChannelNoRedeliveryTest.assertEquals((String)"Only the original attempt", (int)1, (int)counter);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").useOriginalMessage().maximumRedeliveries(0));
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).process((Processor)new MyFailProcessor())).to("mock:b");
            }
        };
    }

    public static final class MyFailProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            counter++;
            throw new IllegalArgumentException("Forced");
        }
    }
}

