/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class ChannelTest
extends ContextTestSupport {
    private static int counter;

    @Override
    protected void setUp() throws Exception {
        this.disableJMX();
        super.setUp();
    }

    public void testChannel() throws Exception {
        counter = 0;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").maximumRedeliveries(2).redeliveryDelay(0L).logStackTrace(false));
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        if (counter++ < 1) {
                            throw new IllegalArgumentException("Damn");
                        }
                    }
                })).delay(10L).to("mock:result");
            }
        };
    }
}

