/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagedRouteStopAndStartTest;

public class ManagedRouteStopAndStartCleanupTest
extends ManagedRouteStopAndStartTest {
    @Override
    public void testStopAndStartRoute() throws Exception {
        if (ManagedRouteStopAndStartCleanupTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteStopAndStartCleanupTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/managed", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        Thread.sleep(1000L);
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRouteStopAndStartCleanupTest.assertEquals((long)1L, (long)completed);
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 1 consumer", (int)1, (int)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 2 processors", (int)2, (int)set.size());
        this.log.info(">>>>>>>>>>>>>>>>>> invoking stop <<<<<<<<<<<<<<<<<<<<<");
        mbeanServer.invoke(on, "stop", null, null);
        this.log.info(">>>>>>>>>>>>>>>>>> invoking stop DONE <<<<<<<<<<<<<<<<<<<<<");
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be stopped", (String)ServiceStatus.Stopped.name(), (String)state);
        set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 0 consumer", (int)0, (int)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 0 processor", (int)0, (int)set.size());
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.setResultWaitTime(3000L);
        this.template.sendBodyAndHeader("file://target/managed", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        mock.assertIsNotSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.log.info(">>>>>>>>>>>>>>>>> invoking start <<<<<<<<<<<<<<<<<<");
        mbeanServer.invoke(on, "start", null, null);
        this.log.info(">>>>>>>>>>>>>>>>> invoking start DONE <<<<<<<<<<<<<<<<<<");
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 1 consumer", (int)1, (int)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedRouteStopAndStartCleanupTest.assertEquals((String)"Should be 2 processors", (int)2, (int)set.size());
        mock.assertIsSatisfied();
        Thread.sleep(1000L);
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRouteStopAndStartCleanupTest.assertEquals((long)2L, (long)completed);
    }
}

