/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedProducerRecipientListRegisterAlwaysTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setRegisterAlways(Boolean.valueOf(true));
        return context;
    }

    public void testProducer() throws Exception {
        if (ManagedProducerRecipientListRegisterAlwaysTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:result");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=producers,*"), null);
        ManagedProducerRecipientListRegisterAlwaysTest.assertEquals((int)2, (int)set.size());
        Iterator<ObjectName> it = set.iterator();
        for (int i = 0; i < 2; ++i) {
            ObjectName on = it.next();
            boolean registered = mbeanServer.isRegistered(on);
            ManagedProducerRecipientListRegisterAlwaysTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
            String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            ManagedProducerRecipientListRegisterAlwaysTest.assertTrue((String)uri, (uri.equals("direct://start") || uri.equals("mock://result") ? 1 : 0) != 0);
            String state = (String)mbeanServer.getAttribute(on, "State");
            ManagedProducerRecipientListRegisterAlwaysTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").recipientList((Expression)this.header("foo"));
            }
        };
    }
}

